#import <Foundation/Foundation.h>

#import "PALDefines.h"

/** The PALSettings class stores SDK wide settings. */
PAL_EXTERN
NS_SWIFT_NAME(Settings)
@interface PALSettings : NSObject

/**
 * Specify if the ad request is directed to a child or user of an unknown age (for example,
 * TFCD or TFUA). Default value is false.
 */
@property(nonatomic) BOOL directedForChildOrUnknownAge;

/**
 * Whether to force Limited Ads mode for the ad request. When unset or set to false, PAL will
 * automatically determine the Limited Ads status from TCF data set by a CMP. When set to true,
 * Limited Ads mode will be used regardless of TCF signals. In Limited Ads mode, PAL will not
 * store, access, or send user identifiers for ad serving purposes. When programmatic limited
 * ads are enabled, invalid traffic detection-only storage may still be used; see {@link
 * PALGoogleAdManagerSettings}. For more information about limited ads, see <a
 * href="https://support.google.com/admanager/answer/9882911">this general article</a> and <a
 * href="https://developers.google.com/ad-manager/pal/ios/limited-ads-first-party-identifier-settings">
 * this PAL-specific article</a>.
 */
@property(nonatomic) BOOL forceLimitedAds;

@end
