#import <Foundation/Foundation.h>

#import "PALDefines.h"

/** PAL settings reflecting settings configured in Google Ad Manager. */
PAL_EXTERN
NS_SWIFT_NAME(GoogleAdManagerSettings)
@interface PALGoogleAdManagerSettings : NSObject

/**
 * Specifies whether to disable first-party identifiers used for ad selection.
 *
 * <p>If you updated the "First party identifiers for ads on apps" setting in Ad Manager within
 * Admin > Global settings, set this value to true to disable such identifiers in PAL.
 *
 * <p>Note that this setting does not apply to the use of storage for invalid traffic detection.
 */
@property(nonatomic) BOOL disableFirstPartyIdentifiers;

/**
 * Specifies whether to disable invalid traffic detection-only storage used for <a
 * href="https://support.google.com/admanager/answer/9882911">limited ads</a>.
 *
 * <p>If you updated the "Programmatic limited ads" setting in Ad Manager within Admin > Global
 * settings, set this value to true to disable such storage for limited ads in PAL.
 *
 * <p>Note that this setting does not apply to non-limited ads.
 */
@property(nonatomic) BOOL disableLimitedAdsStorage;

@end
